/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.user.provider.file;

import com.opensymphony.user.provider.file.FileGroupsCache;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.log4j.Logger;

class SerializableGroupsCache
extends FileGroupsCache
implements Serializable {
    protected static final Logger log = Logger.getLogger(SerializableGroupsCache.class);

    public SerializableGroupsCache(String storeFile, String storeFileType) {
        super(storeFile, storeFileType);
        this.load();
    }

    public boolean load() {
        try {
            ObjectInputStream ois = new ObjectInputStream(this.getInputStreamFromStoreFile());
            SerializableGroupsCache g = (SerializableGroupsCache)ois.readObject();
            this.groups = g.groups;
            return true;
        }
        catch (Exception e) {
            log.fatal((Object)("cannot load from file " + this.storeFile + ". Create a new blank store."), (Throwable)e);
            return false;
        }
    }

    public boolean store() {
        try {
            FileOutputStream fos = new FileOutputStream(new File(this.storeFile));
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this);
            fos.close();
            return true;
        }
        catch (Exception e) {
            log.fatal((Object)("cannot store in file " + this.storeFile + "."), (Throwable)e);
            return false;
        }
    }
}

