/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.soap;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;

public class InvokeTag
extends TagSupport {
    private String var;
    private String endpoint = null;
    private String namespace = null;
    private String method = null;
    private Service service;
    private Object params;

    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        if (this.endpoint == null) {
            throw new MissingAttributeException("endpoint");
        }
        if (this.namespace == null) {
            throw new MissingAttributeException("namespace");
        }
        if (this.method == null) {
            throw new MissingAttributeException("method");
        }
        Object[] params = this.getParamArray();
        if (params == null) {
            params = new Object[]{this.getBodyText()};
        } else {
            this.invokeBody(output);
        }
        Service service = this.getService();
        if (service == null) {
            service = this.createService();
        }
        Object answer = null;
        try {
            Call call = (Call)service.createCall();
            call.setTargetEndpointAddress(new URL(this.endpoint));
            call.setOperationName(new QName(this.namespace, this.method));
            answer = call.invoke(params);
        }
        catch (MalformedURLException e) {
            throw new JellyTagException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new JellyTagException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new JellyTagException((Throwable)e);
        }
        if (this.var == null) {
            throw new JellyTagException("Not implemented yet; should stream results as XML events. Results: " + answer);
        }
        this.context.setVariable(this.var, answer);
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setParams(Object params) {
        this.params = params;
    }

    protected Service createService() {
        return new Service();
    }

    protected Object[] getParamArray() {
        if (this.params == null) {
            return null;
        }
        if (this.params instanceof Object[]) {
            return (Object[])this.params;
        }
        if (this.params instanceof Collection) {
            Collection coll = (Collection)this.params;
            return coll.toArray();
        }
        return new Object[]{this.params};
    }
}

