/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.sql;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.tags.Resources;
import org.apache.commons.jelly.tags.sql.DataSourceUtil;

public class TransactionTag
extends TagSupport {
    private static final String TRANSACTION_READ_COMMITTED = "read_committed";
    private static final String TRANSACTION_READ_UNCOMMITTED = "read_uncommitted";
    private static final String TRANSACTION_REPEATABLE_READ = "repeatable_read";
    private static final String TRANSACTION_SERIALIZABLE = "serializable";
    protected Object rawDataSource;
    protected boolean dataSourceSpecified;
    private Connection conn;
    private int isolation = 0;
    private int origIsolation;

    public void setDataSource(Object dataSource) {
        this.rawDataSource = dataSource;
        this.dataSourceSpecified = true;
    }

    public void doTag(XMLOutput output) throws JellyTagException {
        if (this.rawDataSource == null && this.dataSourceSpecified) {
            throw new JellyTagException(Resources.getMessage((String)"SQL_DATASOURCE_NULL"));
        }
        DataSource dataSource = DataSourceUtil.getDataSource(this.rawDataSource, this.context);
        try {
            this.conn = dataSource.getConnection();
            this.origIsolation = this.conn.getTransactionIsolation();
            if (this.origIsolation == 0) {
                throw new JellyTagException(Resources.getMessage((String)"TRANSACTION_NO_SUPPORT"));
            }
            if (this.isolation != 0 && this.isolation != this.origIsolation) {
                this.conn.setTransactionIsolation(this.isolation);
            }
            this.conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new JellyTagException(Resources.getMessage((String)"ERROR_GET_CONNECTION", (Object)e.getMessage()));
        }
        boolean finished = false;
        try {
            this.invokeBody(output);
            finished = true;
        }
        catch (Exception e) {
            if (this.conn != null) {
                try {
                    this.conn.rollback();
                }
                catch (SQLException s) {
                    // empty catch block
                }
                this.doFinally();
            }
            throw new JellyTagException((Throwable)e);
        }
        try {
            try {
                this.conn.commit();
            }
            catch (SQLException e) {
                throw new JellyTagException(Resources.getMessage((String)"TRANSACTION_COMMIT_ERROR", (Object)e.getMessage()));
            }
            Object var7_8 = null;
            this.doFinally();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.doFinally();
            throw throwable;
        }
    }

    public void setIsolation(String iso) throws JellyTagException {
        if (TRANSACTION_READ_COMMITTED.equals(iso)) {
            this.isolation = 2;
        } else if (TRANSACTION_READ_UNCOMMITTED.equals(iso)) {
            this.isolation = 1;
        } else if (TRANSACTION_REPEATABLE_READ.equals(iso)) {
            this.isolation = 4;
        } else if (TRANSACTION_SERIALIZABLE.equals(iso)) {
            this.isolation = 8;
        } else {
            throw new JellyTagException(Resources.getMessage((String)"TRANSACTION_INVALID_ISOLATION"));
        }
    }

    public Connection getSharedConnection() {
        return this.conn;
    }

    protected void doFinally() {
        if (this.conn != null) {
            try {
                if (this.isolation != 0 && this.isolation != this.origIsolation) {
                    this.conn.setTransactionIsolation(this.origIsolation);
                }
                this.conn.setAutoCommit(true);
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.conn = null;
    }
}

