/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.sql;

import javax.sql.DataSource;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.tags.Resources;
import org.apache.commons.jelly.tags.sql.DataSourceUtil;
import org.apache.commons.jelly.tags.sql.DataSourceWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SetDataSourceTag
extends TagSupport {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jelly$tags$sql$SetDataSourceTag == null ? (class$org$apache$commons$jelly$tags$sql$SetDataSourceTag = SetDataSourceTag.class$("org.apache.commons.jelly.tags.sql.SetDataSourceTag")) : class$org$apache$commons$jelly$tags$sql$SetDataSourceTag));
    protected Object dataSource;
    protected boolean dataSourceSpecified;
    protected String jdbcURL;
    protected String driverClassName;
    protected String userName;
    protected String password;
    private String scope = "page";
    private String var;
    static /* synthetic */ Class class$org$apache$commons$jelly$tags$sql$SetDataSourceTag;

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setDataSource(Object dataSource) {
        this.dataSource = dataSource;
        this.dataSourceSpecified = true;
    }

    public void setDriver(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setUrl(String jdbcURL) {
        this.jdbcURL = jdbcURL;
    }

    public void setUser(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void doTag(XMLOutput output) throws JellyTagException {
        DataSource ds = null;
        if (this.dataSource != null) {
            ds = DataSourceUtil.getDataSource(this.dataSource, this.context);
        } else {
            if (this.dataSourceSpecified) {
                throw new JellyTagException(Resources.getMessage((String)"SQL_DATASOURCE_NULL"));
            }
            DataSourceWrapper dsw = new DataSourceWrapper();
            try {
                if (this.driverClassName != null) {
                    dsw.setDriverClassName(this.driverClassName);
                }
            }
            catch (Exception e) {
                log.error((Object)("Could not load driver class: " + e), (Throwable)e);
                throw new JellyTagException(Resources.getMessage((String)"DRIVER_INVALID_CLASS", (Object)e.getMessage()));
            }
            dsw.setJdbcURL(this.jdbcURL);
            dsw.setUserName(this.userName);
            dsw.setPassword(this.password);
            ds = dsw;
        }
        if (this.var != null) {
            this.context.setVariable(this.var, (Object)ds);
        } else {
            this.context.setVariable("org.apache.commons.jelly.sql.DataSource", (Object)ds);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

