/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.sql;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.jelly.tags.Resources;
import org.apache.commons.jelly.util.ClassLoaderUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSourceWrapper
implements DataSource {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jelly$tags$sql$DataSourceWrapper == null ? (class$org$apache$commons$jelly$tags$sql$DataSourceWrapper = DataSourceWrapper.class$("org.apache.commons.jelly.tags.sql.DataSourceWrapper")) : class$org$apache$commons$jelly$tags$sql$DataSourceWrapper));
    private String driverClassName;
    private String jdbcURL;
    private String userName;
    private String password;
    static /* synthetic */ Class class$org$apache$commons$jelly$tags$sql$DataSourceWrapper;

    public void setDriverClassName(String driverClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading JDBC driver: [" + driverClassName + "]"));
        }
        this.driverClassName = driverClassName;
        ClassLoaderUtils.getClassLoader(this.getClass()).loadClass(driverClassName).newInstance();
    }

    public void setJdbcURL(String jdbcURL) {
        this.jdbcURL = jdbcURL;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Connection getConnection() throws SQLException {
        Connection conn = null;
        if (this.userName != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating connection from url: " + this.jdbcURL + " userName: " + this.userName));
            }
            conn = DriverManager.getConnection(this.jdbcURL, this.userName, this.password);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating connection from url: " + this.jdbcURL));
            }
            conn = DriverManager.getConnection(this.jdbcURL);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created connection: " + conn));
        }
        return conn;
    }

    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException(Resources.getMessage((String)"NOT_SUPPORTED"));
    }

    public int getLoginTimeout() throws SQLException {
        throw new SQLException(Resources.getMessage((String)"NOT_SUPPORTED"));
    }

    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLException(Resources.getMessage((String)"NOT_SUPPORTED"));
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        throw new SQLException(Resources.getMessage((String)"NOT_SUPPORTED"));
    }

    public synchronized void setLogWriter(PrintWriter out) throws SQLException {
        throw new SQLException(Resources.getMessage((String)"NOT_SUPPORTED"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

