/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.sql;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.tags.Resources;
import org.apache.commons.jelly.tags.sql.DataSourceWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSourceUtil {
    private static final String ESCAPE = "\\";
    private static final String TOKEN = ",";
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jelly$tags$sql$DataSourceUtil == null ? (class$org$apache$commons$jelly$tags$sql$DataSourceUtil = DataSourceUtil.class$("org.apache.commons.jelly.tags.sql.DataSourceUtil")) : class$org$apache$commons$jelly$tags$sql$DataSourceUtil));
    static /* synthetic */ Class class$org$apache$commons$jelly$tags$sql$DataSourceUtil;

    static DataSource getDataSource(Object rawDataSource, JellyContext pc) throws JellyTagException {
        DataSource dataSource = null;
        if (rawDataSource == null) {
            rawDataSource = pc.getVariable("org.apache.commons.jelly.sql.DataSource");
        }
        if (rawDataSource == null) {
            return null;
        }
        if (rawDataSource instanceof String) {
            try {
                InitialContext ctx = new InitialContext();
                Context envCtx = (Context)ctx.lookup("java:comp/env");
                dataSource = (DataSource)envCtx.lookup((String)rawDataSource);
            }
            catch (NamingException ex) {
                dataSource = DataSourceUtil.getDataSource((String)rawDataSource);
            }
        } else if (rawDataSource instanceof DataSource) {
            dataSource = (DataSource)rawDataSource;
        } else {
            throw new JellyTagException(Resources.getMessage((String)"SQL_DATASOURCE_INVALID_TYPE"));
        }
        return dataSource;
    }

    private static DataSource getDataSource(String params) throws JellyTagException {
        DataSourceWrapper dataSource = new DataSourceWrapper();
        String[] paramString = new String[4];
        int escCount = 0;
        int aryCount = 0;
        int begin = 0;
        int index = 0;
        while (index < params.length()) {
            char nextChar = params.charAt(index);
            if (TOKEN.indexOf(nextChar) != -1 && escCount == 0) {
                paramString[aryCount] = params.substring(begin, index);
                begin = index + 1;
                if (++aryCount > 4) {
                    throw new JellyTagException(Resources.getMessage((String)"JDBC_PARAM_COUNT"));
                }
            }
            escCount = ESCAPE.indexOf(nextChar) != -1 ? ++escCount : 0;
            ++index;
        }
        paramString[aryCount] = params.substring(begin);
        dataSource.setJdbcURL(paramString[0]);
        if (paramString[1] != null) {
            try {
                dataSource.setDriverClassName(paramString[1]);
            }
            catch (Exception ex) {
                throw new JellyTagException(Resources.getMessage((String)"DRIVER_INVALID_CLASS", (Object)ex.getMessage()));
            }
        }
        dataSource.setUserName(paramString[2]);
        dataSource.setPassword(paramString[3]);
        return dataSource;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

