/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.memory;

import com.atlassian.cache.Cache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryCache<K, V>
implements Cache<K, V> {
    private final String cacheName;
    private final Map<K, V> cache = new ConcurrentHashMap();

    public MemoryCache(String cacheName) {
        if (cacheName == null) {
            throw new IllegalArgumentException("Cache name must not be null when constructing a MemoryCache!");
        }
        this.cacheName = cacheName;
    }

    public String getName() {
        return this.cacheName;
    }

    public Collection<K> getKeys() {
        return new ArrayList<K>(this.cache.keySet());
    }

    public V get(K key) {
        return this.cache.get(key);
    }

    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    public void remove(K key) {
        this.cache.remove(key);
    }

    public void removeAll() {
        this.cache.clear();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryCache other = (MemoryCache)obj;
        return other.cacheName.equals(this.cacheName);
    }

    public int hashCode() {
        return 3 + this.cacheName.hashCode();
    }
}

