package com.atlassian.confluence.extra.leftnavigation;

import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.bandana.BandanaManager;

public class SettingsManager
{
    private BandanaManager bandanaManager;
    // use the theme key as identifier
    public String THEMEKEY = "com.atlassian.confluence.themes.leftnavigation:leftnavigation";

    /**
     * Creates a Manager to save and load Theme settings via Bandana.
     *
     * @param bandanaManager
     */
    public SettingsManager(BandanaManager bandanaManager)
    {
        setBandanaManager(bandanaManager);
    }

    /**
     * returns the theme settings for the space given.
     * If no space is give, the global settings are returned.
     *
     * @return LeftNavSettings
     */

    public LeftNavSettings getSpaceThemeSettings(String spaceKey)
    {
        return (LeftNavSettings) bandanaManager.getValue(new ConfluenceBandanaContext(spaceKey), THEMEKEY, false);
    }


    /**
     * returns the global theme settings
     *
     * @return
     */
    public LeftNavSettings getGlobalThemeSettings()
    {
        return (LeftNavSettings) bandanaManager.getValue(new ConfluenceBandanaContext(), THEMEKEY, false);
    }

    /**
     * saves the Theme Settings via Bandana in context to the given space.
     * If the space is null, the settings will be saved as global settings.
     *
     * @param settings
     * @param spaceKey
     */
    public void setSpaceThemeSettings(LeftNavSettings settings, String spaceKey)
    {
        bandanaManager.setValue(new ConfluenceBandanaContext(spaceKey), THEMEKEY, settings);
    }

    public void setGlobalThemeSettings(LeftNavSettings settings)
    {
        bandanaManager.setValue(new ConfluenceBandanaContext(), THEMEKEY, settings);
    }

    public void setBandanaManager(BandanaManager bandanaManager)
    {
        this.bandanaManager = bandanaManager;
    }
}
