package com.atlassian.confluence.extra.workflow.model;

import com.atlassian.confluence.extra.workflow.Operation;
import com.atlassian.confluence.extra.workflow.Condition;
import com.atlassian.confluence.extra.workflow.WorkflowType;

import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.lang.reflect.Constructor;

/**
 * Created by IntelliJ IDEA.
 * User: Tomd
 * Date: 23/05/2005
 * Time: 14:06:55
 * To change this template use File | Settings | File Templates.
 */
public class OperationModel
{
    Operation op;
    List conditions = new ArrayList();

    public OperationModel(Operation o)
    {
        op = o;
        for (Iterator i = op.getConditions().iterator(); i.hasNext();)
        {
            Condition c = (Condition)i.next();
            String className = c.getClass().getName() + "Model";
            try
            {
            Constructor constructor = Class.forName(className).getConstructor(new Class[] { Condition.class });
            conditions.add(constructor.newInstance(new Object[] {c}));
            }
            catch (Exception e)
            {
                throw new RuntimeException("error creating instance of " + className,e);
            }
        }
    }

    public void applyChanges(WorkflowType type)
    {
        for (Iterator i = conditions.iterator(); i.hasNext();)
        {
            ConditionModel cm = (ConditionModel)i.next();
            cm.applyChanges(type);
        }
    }

    public List getConditions()
    {
        return conditions;
    }
}
