package com.atlassian.confluence.extra.workflow;

import com.atlassian.confluence.pages.actions.AbstractPageAction;
import com.atlassian.confluence.extra.workflow.model.OperationModel;
import com.opensymphony.webwork.ServletActionContext;

import java.util.*;

/**
 * Created by IntelliJ IDEA.
 * User: Tomd
 * Date: 17/05/2005
 * Time: 16:54:35
 * To change this template use File | Settings | File Templates.
 */
public class WorkflowTypeAction extends AbstractPageAction
{
    private Map buttonAction = new HashMap();
    private String operation;
    private String operationname;
    private Map operations;

    public String getAddtrigger()
    {
        return addtrigger;
    }

    public void setAddtrigger(String addtrigger)
    {
        this.addtrigger = addtrigger;
    }

    private String addtrigger = null;

    public WorkflowTypeAction()
    {
        for (int i = 0; i < 100; ++i)
        {
            addaction.add(null);
        }
    }

    public Map getButtonAction()
    {
        return buttonAction;
    }

    public List getAddaction()
    {
        return addaction;
    }

    public List addaction = new ArrayList(100);

    private String type;

    public void setType(String type)
    {
        this.type = type;
    }

    public WorkflowType getWorkflowType()
    {
        return WorkflowManager.findType(ServletActionContext.getRequest().getParameter("type"));
    }

    public String deleteAction()
    {
        Trigger t = getTrigger();
        int actionIndex = getIntParam("action");
        t.deleteAction(actionIndex);
        return SUCCESS;
    }

    public String deleteTrigger()
    {
        Trigger t = getTrigger();
        getWorkflowType().deleteTrigger(t.getId());
        return SUCCESS;
    }

    public String deleteOperation()
    {
        getWorkflowType().deleteOperation(operation);
        return SUCCESS;
    }

    private String addAction()
    {
        List triggers = getWorkflowType().getTriggers();
        for (int i = 0; i < triggers.size(); ++i)
        {
            if (addaction.get(i) != null && ((String[]) addaction.get(i))[0].length() > 0)
            {
                Trigger t = (Trigger) triggers.get(i);
                String actionClassName = ((String[]) addaction.get(i))[0];
                try
                {
                    Class clazz = Class.forName(actionClassName);
                    t.addAction((Action) clazz.newInstance());
                }
                catch (Exception e)
                {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        }
        return SUCCESS;
    }

    public String execute()
    {
        if (buttonAction.containsKey("addAction"))
        {
            return addAction();
        }
        else if (buttonAction.containsKey("addTrigger"))
        {
            return addTrigger();
        }
        else if (buttonAction.containsKey("deleteAction"))
        {
            return deleteAction();
        }
        else if (buttonAction.containsKey("addOperation"))
        {
            return addOperation();
        }
        for (Iterator i = operations.values().iterator(); i.hasNext();)
        {
            OperationModel opm = (OperationModel)i.next();
            opm.applyChanges(getWorkflowType());
        }
        return SUCCESS;
    }

    private String addOperation()
    {
        if (operationname != null)
        {
            getWorkflowType().addOperation(new DefaultOperation(new ArrayList(),operationname, operationname));
        }
        return SUCCESS;
    }

    private String addTrigger()
    {
        if (addtrigger != null)
        {
            try
            {
                Class clazz = Class.forName(addtrigger);
                getWorkflowType().addTrigger((Trigger) clazz.newInstance());
            }
            catch (Exception e)
            {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return SUCCESS;
    }

    private Trigger getTrigger()
    {
        int triggerId = Integer.parseInt(ServletActionContext.getRequest().getParameter("trigger"));
        return getWorkflowType().getTriggerById(triggerId);
    }

    private int getIntParam(String name)
    {
        return Integer.parseInt(ServletActionContext.getRequest().getParameter(name));
    }

    public void setOperation(String operation)
    {
        this.operation = operation;
    }

    public void setOperationname(String operationname)
    {
        this.operationname = operationname;
    }

    public Map getOperations()
    {
        if (operations == null)
        {
            operations = new HashMap();
            for (Iterator i = getWorkflowType().getNonInitOperations().iterator(); i.hasNext();)
            {
                Operation op = (Operation)i.next();
                operations.put(op.getName(), new OperationModel(op));
            }
        }
        return operations;
    }
}
