package com.atlassian.confluence.extra.workflow;


import com.atlassian.user.User;

import java.util.Map;
import java.util.List;
import java.util.Collection;

/**
 * Created by IntelliJ IDEA.
 * User: Tomd
 * Date: 3/05/2005
 * Time: 11:45:25
 * To change this template use File | Settings | File Templates.
 */
public interface WorkflowType
{
    String getName();
    Map getAvailableOperations(WorkflowClient client, User user);
    void operationPerformed(Operation op, WorkflowClient client, User user);
    String getDescription();
    State getStateById(String stateId);
    boolean isUserParticipating(User user);
    List getInitActions();
    Collection getNonInitOperations();
    List getNonInitTriggers();
    Trigger getTriggerById(int id);
    Operation getOperationByName(String name);
    Collection getStates();
    /**
     * Get a collection of strings naming the roles which may be used in this workflow.
     */
    Collection getRoles();

    /**
     * Get a collection of Strings naming the participating groups.
     */
    Collection getGroups();

    /**
     * Get a Collection of ActionTypes available to this workflow type
     */
    Collection getActionTypes();

    /**
     * Get a Collection of all the Triggers in this workflow type.
     * @return
     */
    List getTriggers();

    void deleteTrigger(int id);

    void addTrigger(Trigger trigger);

    /**
     * Get a Collection of TriggerTypes available to this workflow type
     */
    Collection getTriggerTypes();

    void deleteOperation(String name);

    void addOperation(Operation operation);
}
