package com.atlassian.confluence.extra.workflow;

import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.extra.workflow.model.WorkflowTasksModel;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import org.apache.log4j.Category;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: tomd
 * Date: 7/05/2005
 * Time: 13:55:48
 * To change this template use File | Settings | File Templates.
 */
public class WorkflowTasksMacro extends BaseMacro
{
    protected static final Category log = Category.getInstance(WorkflowTasksMacro.class);
    private PageManager pageManager;
    private ContentPropertyManager contentPropertyManager;

    public boolean isInline()
    {
        return false;
    }

    public boolean hasBody()
    {
        return false;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public RenderMode getBodyRenderMode()
    {
        return RenderMode.NO_RENDER;
    }

    public String execute(Map parameters, String body,
                          RenderContext renderContext
                          ) throws MacroException
    {
        // retrieve a reference to the body object this macro is in
        Page contentObject = (Page)((PageContext)renderContext).getEntity();
        List pages = pageManager.getDescendents(contentObject);
        WorkflowTasksModel model = new WorkflowTasksModel();
        for (Iterator i = pages.iterator(); i.hasNext();)
        {
            Page p =  (Page) i.next();
            if (ConfluencePageWorkflowClient.isWorkflowPage(p, contentPropertyManager))
            {
                model.add(new ConfluencePageWorkflowClient(p, contentPropertyManager), AuthenticatedUserThreadLocal.getUser());
            }
        }
        // test
        for (Iterator i = model.getStates().iterator(); i.hasNext();)
        {
            List l = model.getTasksForState((State)i.next());
        }
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("tasksModel", model);
        try
        {
            return VelocityUtils.getRenderedTemplate("templates/extra/workflow/workflowtasksmacro.vm", contextMap);
        }
        catch (Exception e)
        {
            log.error("Error while trying to display Macro!", e);
            throw new MacroException(e.getMessage(),e);
        }
    }

    public void setPageManager(PageManager pageManager)
    {
        this.pageManager = pageManager;
    }

    public void setContentPropertyManager(ContentPropertyManager contentPropertyManager)
    {
        this.contentPropertyManager = contentPropertyManager;
    }
}
