package com.atlassian.confluence.extra.workflow;

import com.atlassian.user.User;

/**
 * Created by IntelliJ IDEA.
 * User: Tomd
 * Date: 13/05/2005
 * Time: 15:01:37
 * To change this template use File | Settings | File Templates.
 */
public class UserNotAssignedAs implements Condition
{
    public String getRole()
    {
        return role;
    }

    public void setRole(String role)
    {
        this.role = role;
    }

    private String role;

    public UserNotAssignedAs(String role)
    {
        this.role = role;
    }

    public boolean allowed(User user, WorkflowClient client)
    {
        String assignment = client.getValue("assignment:" + role);
        return assignment == null || !assignment.equals(user.getName());
    }

    public String getDescription()
    {
        return "the user is not assigned to the page as '" + role + "'";
    }
}
