package com.atlassian.confluence.extra.workflow;

import com.atlassian.user.User;

import java.util.Set;
import java.util.HashSet;
import java.util.Arrays;
import java.util.Iterator;

/**
 * Created by IntelliJ IDEA.
 * User: Tomd
 * Date: 23/05/2005
 * Time: 11:48:02
 * To change this template use File | Settings | File Templates.
 */
public class StateSetCondition implements Condition
{
    private String[] states;
    private Set availableStates;

    StateSetCondition(State[] states)
    {
        availableStates = new HashSet(Arrays.asList(states));
    }

    public boolean allowed(User user, WorkflowClient client)
    {
        return availableStates.contains(client.getState());
    }

    public String getDescription()
    {
        return  " client is in " + getStatesList();
    }

    private String getStatesList()
    {
        StringBuffer sb = new StringBuffer();
        if (availableStates.size() == 0)
        {
            return "no states";
        }
        else if (availableStates.size() == 1)
        {
            sb.append("state ");
        }
        else
        {
            sb.append("states ");
        }

        String sep = "";
        for (Iterator i = availableStates.iterator(); i.hasNext();)
        {
            sb.append(sep);
            sb.append("<b>" + ((State)i.next()).getDescription() + "</b>");
            sep = ", ";
        }
        return sb.toString();
    }

    public Set getStates()
    {
        return availableStates;
    }
}
