package com.atlassian.confluence.extra.workflow;

import com.atlassian.user.User;

/**
 * Created by IntelliJ IDEA.
 * User: Tomd
 * Date: 4/05/2005
 * Time: 12:03:09
 * To change this template use File | Settings | File Templates.
 */
public class StateChangeAction extends BaseAction
{
    public State getToState()
    {
        return toState;
    }

    public void setToState(State toState)
        {
            this.toState = toState;
        }
    public void setToStateById(String id)
        {
            this.toState = getTrigger().getOwner().getStateById(id);
        }

    private State toState;

    public StateChangeAction(State toState)
    {
        this.toState = toState;
    }

    public StateChangeAction()
    {
        toState = null;
    }

    public void perform(WorkflowClient client, User user)
    {
        if (!client.getState().equals(toState))
        {
            client.setState(toState);
        }
    }

    public String getDescription()
    {
        return "Change the state to <b>" + toState.getDescription() + "</b>";
    }

    public boolean isConfigError()
    {
        return toState == null;
    }
}
