package com.atlassian.confluence.extra.workflow;

/**
 * Created by IntelliJ IDEA.
 * User: Tomd
 * Date: 3/05/2005
 * Time: 17:08:40
 * To change this template use File | Settings | File Templates.
 */
public class State
{
    private String typeName;
    private String id;
    private String description;
    private String uninvolvedMarkup;

    public State(String type, String id, String description, String uninvolvedMarkup)
    {
        this.typeName = type;
        this.id = id;
        this.description = description;
        this.uninvolvedMarkup = uninvolvedMarkup;
    }

    public String getId()
    {
        return id;
    }

    public WorkflowType getType()
    {
        return WorkflowManager.findType(typeName);
    }

    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (!(o instanceof State)) return false;

        final State state = (State) o;

        if (!id.equals(state.id)) return false;
        if (!typeName.equals(state.typeName)) return false;

        return true;
    }

    public int hashCode()
    {
        int result;
        result = typeName.hashCode();
        result = 29 * result + id.hashCode();
        return result;
    }

    public String getDescription()
    {
        return description;
    }

    public String getUninvolvedMarkup()
    {
        return uninvolvedMarkup;
    }
}
