package com.atlassian.confluence.extra.workflow;

import bucket.container.ContainerManager;
import com.atlassian.confluence.core.ContentPermission;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.user.User;

import java.util.Date;

/**
 * Created by IntelliJ IDEA.
 * User: Tomd
 * Date: 4/05/2005
 * Time: 14:47:19
 * To change this template use File | Settings | File Templates.
 */
public class RestrictAccessToGroupAction extends BaseAction
{
    private final ContentPermission permission;


    public RestrictAccessToGroupAction(ContentPermission permission)
        {
            this.permission = permission;
        }

    public RestrictAccessToGroupAction()
    {
            this.permission = new ContentPermission();
    }

    public void perform(WorkflowClient client, User user)
    {
        permission.setCreatorName(user.getName());
        permission.setCreationDate(new Date());
        ContentPermissionManager contentPermissionManager = (ContentPermissionManager) ContainerManager.getInstance().getContainerContext().getComponent("contentPermissionManager");
        contentPermissionManager.addContentPermission(permission,((ConfluencePageWorkflowClient)client).getContentEntityObject());
    }

    public String getDescription()
    {
        return "Restrict <b>" + permission.getType() + "</b> permissions to the <b>" + permission.getGroup() + "</b> group.";
    }

    public boolean isConfigError()
    {
        return permission.getType() == null || permission.getGroup() == null;
    }

    public ContentPermission getPermission()
    {
        return permission;
    }
}
