package com.atlassian.confluence.extra.workflow;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.user.User;
import bucket.container.ContainerManager;

/**
 * Created by IntelliJ IDEA.
 * User: Tomd
 * Date: 13/05/2005
 * Time: 12:44:39
 * To change this template use File | Settings | File Templates.
 */
public class ReplaceCurrentVersionWithTaggedVersion extends TagAction
{
    public ReplaceCurrentVersionWithTaggedVersion(String tag)
    {
        super(tag);
    }
    
    public ReplaceCurrentVersionWithTaggedVersion()
    {
        super();
    }

    public void perform(WorkflowClient client, User user)
    {
        ConfluencePageWorkflowClient cpwc = (ConfluencePageWorkflowClient) client;
        ContentEntityObject ceo = cpwc.getContentEntityObject();
        String versionAsString = cpwc.getValue("versiontag." + getTag());
        if (versionAsString != null)
        {
            int version = Integer.parseInt(versionAsString);
            if (version != ceo.getVersion())
            {
                PageManager pageManager = (PageManager) ContainerManager.getComponent("pageManager");
                pageManager.revertContentEntityBackToVersion( ceo, version );
            }
        }
    }

    public String getDescription()
    {
        return "Replace the current version of the page with the version tagged '" + getTag() + "'";
    }
}
