package com.atlassian.confluence.extra.workflow;

import com.atlassian.confluence.core.ContentPermission;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.user.User;

import java.util.Date;

/**
 * Created by IntelliJ IDEA.
 * User: Tomd
 * Date: 4/05/2005
 * Time: 14:51:55
 * To change this template use File | Settings | File Templates.
 */
public class RemovePermissionAction extends BaseAction
{
    private final ContentPermission permission;

    public RemovePermissionAction(ContentPermission permission)
    {
        this.permission = permission;
    }

    public void perform(WorkflowClient client, User user)
    {
        ContentEntityObject cob = ((ConfluencePageWorkflowClient)client).getContentEntityObject();
        permission.setCreatorName(user.getName());
        permission.setCreationDate(new Date());
        cob.removePermission(permission);
    }

    public String getDescription()
    {
        return null;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public boolean isConfigError()
    {
        return false;
    }
}
