package com.atlassian.confluence.extra.workflow;

import com.atlassian.user.User;

import java.util.List;
import java.util.Collections;

/**
 * Created by IntelliJ IDEA.
 * User: tomd
 * Date: 7/05/2005
 * Time: 22:08:26
 * To change this template use File | Settings | File Templates.
 */
public class PageEditOperation implements Operation
{
    public static final String OPERATION_NAME = "pageEdited";

    public String getName()
    {
        return OPERATION_NAME;
    }

    public int getId()
    {
        return 0;
    }

    public boolean isEditable()
    {
        return false;
    }

    public String getDescription()
    {
        return "Edit Page";
    }

    public String getFullDescription()
    {
        return "<b>" + getDescription() + "</b>";
    }

    public boolean availableToUserAndClient(User user, WorkflowClient client)
    {
        // perhaps this should check page-level permissions?
        return false; // so it is never offered to the user, Confluence does that
    }

    public boolean isConfigError()
    {
        return false;
    }

    public List getConditions()
    {
        return Collections.EMPTY_LIST;
    }
}
