package com.atlassian.confluence.extra.workflow;

import com.atlassian.user.User;


/**
 * This interface represents things which can happen when a Trigger fires.
 */
public interface Action
{
    /**
     * Perform the Action on the client, on behalf of the user.
     */
    void perform(WorkflowClient client, User user);

    /**
     * Get a human-readable description of this Action, suitable for including in a description of a workflow.
     * If isConfigError() would return true, this includes a description of the error.
     */
    String getDescription();
    
    /**
     * Test if there is a problem with the way this Action is configured.
     */
    boolean isConfigError();

    /**
     * Get the owning Trigger
     */
    Trigger getTrigger();

    /**
     * Set the owning Trigger
     */
    void setTrigger(Trigger trigger);
}
