package com.atlassian.confluence.extra.userlister;

import com.atlassian.confluence.ConfluenceTestCase;

public class TestUserLister extends ConfluenceTestCase
{
    public void testLogInLogOut()
    {
        UserLister userLister = new UserLister();
        assertEquals(0, userLister.getLoggedInUsers().size());

        userLister.userLoggedIn("user1", "session1");
        userLister.userLoggedIn("user2", "session2");
        assertEquals(2, userLister.getLoggedInUsers().size());
        assertTrue(userLister.getLoggedInUsers().containsKey(("session1")));
        assertTrue(userLister.getLoggedInUsers().containsKey(("session2")));

        userLister.userLoggedOut("session1");
        assertEquals(1, userLister.getLoggedInUsers().size());
        assertFalse(userLister.getLoggedInUsers().containsKey(("session1")));
        assertTrue(userLister.getLoggedInUsers().containsKey(("session2")));

        userLister.userLoggedOut("session1");
        assertEquals(1, userLister.getLoggedInUsers().size());
        assertFalse(userLister.getLoggedInUsers().containsKey(("session1")));
        assertTrue(userLister.getLoggedInUsers().containsKey(("session2")));

        userLister.userLoggedOut("session2");
        assertEquals(0, userLister.getLoggedInUsers().size());
        assertFalse(userLister.getLoggedInUsers().containsKey(("session2")));
    }
}
