package com.atlassian.confluence.extra.userlister;

import com.atlassian.confluence.ConfluenceTestCase;
import com.atlassian.confluence.event.events.security.LoginEvent;
import com.atlassian.confluence.event.events.security.LogoutEvent;
import com.atlassian.confluence.event.events.security.LoginFailedEvent;

public class TestUserListener extends ConfluenceTestCase
{
    UserListener userListener;

    public void setUp() throws Exception
    {
        super.setUp();

        userListener = new UserListener();
    }

    public void tearDown() throws Exception
    {
        super.tearDown();
    }

    public void testHandledClasses()
    {
        Class[] expectedHandledClasses = new Class[]{ LoginEvent.class, LogoutEvent.class, LoginFailedEvent.class};

        assertEquals("handled classes of UserListener have different length", expectedHandledClasses.length, userListener.getHandledEventClasses().length);

        for (int i = 0; i < expectedHandledClasses.length; i++)
        {
            Class expectedHandledClass = expectedHandledClasses[i];

            Class[] actualHandledClasses = userListener.getHandledEventClasses();

            Class actualHandledClass = null;

            for (int j = 0; j < actualHandledClasses.length; j++)
            {
                actualHandledClass = actualHandledClasses[j];

                if (actualHandledClass != expectedHandledClass)
                {
                    actualHandledClass = null;
                    continue;
                }
                else
                    break;
            }

            if (actualHandledClass == null)
                fail("Expected but did not find " + expectedHandledClass);
        }
    }
}
