package com.atlassian.confluence.extra.userlister;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import com.atlassian.confluence.ConfluenceTestCase;
import com.atlassian.confluence.extra.userlister.model.UserList;
import com.atlassian.confluence.extra.userlister.model.ListedUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.DefaultUserAccessor;
import com.atlassian.user.User;
import com.atlassian.user.repository.DefaultRepository;
import com.atlassian.user.impl.memory.MemoryUserManager;
import com.atlassian.user.impl.memory.provider.MemoryProvider;
import com.atlassian.user.impl.osuser.security.password.OSUPasswordEncryptor;
import com.atlassian.user.UserManager;

public class TestUserList extends ConfluenceTestCase
{
    private UserAccessor userAccessor;
    private UserList userList;
    private Map eligibleUsers;
    private List allUsers;

    public void setUp() throws Exception
    {
        super.setUp();

        UserManager userManager = new MemoryUserManager(new DefaultRepository(), new MemoryProvider(), new OSUPasswordEncryptor());
        userAccessor = new DefaultUserAccessor();
        userAccessor.setUserManager(userManager);

        userList = new UserList(null, userAccessor);

        allUsers = new ArrayList();
        addUser("user1", allUsers);
        addUser("user2", allUsers);
        addUser("user3", allUsers);

        eligibleUsers = new HashMap();
        eligibleUsers.put("session1", "user1");
    }

    public void testBuildAllUsers() throws Exception
    {
        userList.build(false, eligibleUsers.values(), false);

        List users = userList.getUsers();
        Object[] userNames = users.toArray();
        assertEquals(3, users.size());
        assertUserState(userNames, 0, "user1", true);
        assertUserState(userNames, 1, "user2", false);
        assertUserState(userNames, 2, "user3", false);
    }

    public void testBuildLoggedInUsers() throws Exception
    {
        userList.build(true, eligibleUsers.values(), true);

        List users = userList.getUsers();
        Object[] userNames = users.toArray();
        assertEquals(1, users.size());
        assertUserState(userNames, 0, "user1", true);
    }

    public void testBuildLoggedOutUsers() throws Exception
    {
        userList.build(true, eligibleUsers.values(), false);

        List users = userList.getUsers();
        Object[] userNames = users.toArray();
        assertEquals(2, users.size());
        assertUserState(userNames, 0, "user2", false);
        assertUserState(userNames, 1, "user3", false);
    }

    private User addUser(String userName, List users) throws Exception
    {
        User user = userAccessor.createUser(userName);
        users.add(user);
        return user;
    }

    private void assertUserState(Object[] userNames, int index, String name, boolean loggedIn)
    {
        ListedUser listedUser = ((ListedUser) userNames[index]);
        assertEquals(name, listedUser.getName());
        assertEquals(loggedIn, listedUser.isLoggedIn());
    }
}
