package com.atlassian.confluence.extra.userlister.model;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerUtils;

import java.util.*;

/**
 * User: nickf
 * Date: Sep 8, 2004
 */
public class UserList
{
    private String groupName;
    private List users;
    private UserAccessor userAccessor;

    public UserList(String groupName, UserAccessor userAccessor)
    {
        this.groupName = groupName;
        this.userAccessor = userAccessor;
    }

    public String getGroup()
    {
        return groupName;
    }

    public List getUsers()
    {
        return users;
    }

    public boolean build(boolean filterOnline, Collection loggedInUsers, boolean include)
    {
        List usernames = getGroupUsers();

        if (usernames == null)
            return false;

        users = new ArrayList(usernames.size());

        for (Iterator iterator = usernames.iterator(); iterator.hasNext();)
        {
            Object next = iterator.next();
            User user = null;
            if (next instanceof User)
                user = (User) next;
            else
                user = userAccessor.getUser((String) next);

            // If it's an anonymous user, then we can't do anything (CONF-5821)
            if (user == null)
                continue;

            // we don't know group users are active, so check.
            if (groupName != null && userAccessor.isDeactivated(user))
                continue;

            boolean isLoggedIn = loggedInUsers.contains(user.getName());
            if (!filterOnline || isLoggedIn == include)
            {
                users.add(new ListedUser(user, isLoggedIn));
            }
        }

        sortUsers();

        return true;
    }

    private List getGroupUsers()
    {
        Pager usernames = null;

        if (groupName == null)
        {
            usernames = userAccessor.getUsersWithConfluenceAccess();
        }
        else //go hunting for the specific group
        {
            Group group = userAccessor.getGroup(groupName);

            if (group != null)
                usernames = userAccessor.getMemberNames(group);
        }

        return PagerUtils.toList(usernames);
    }

    private void sortUsers()
    {
        Collections.sort(users, new Comparator()
        {
            public int compare(Object o1, Object o2)
            {
                ListedUser u1 = (ListedUser) o1;
                ListedUser u2 = (ListedUser) o2;
                if (u1 == null && u2 == null)
                    return 0;
                if (u2 == null)
                    return -1;
                if (u1 == null)
                    return 1;
                String name1 = u1.getFullName();
                String name2 = u2.getFullName();
                if (name1 == null)
                    name1 = u1.getName();
                if (name2 == null)
                    name2 = u2.getName();
                if (name1 == null || name2 == null)
                    throw new RuntimeException("Null user name");
                else
                    return name1.toLowerCase().compareTo(name2.toLowerCase());
            }
        });
    }
}
