package com.atlassian.confluence.extra.tasklist;

import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.RenderContext;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.extra.tasklist.model.TaskList;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.opensymphony.webwork.ServletActionContext;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

import org.apache.log4j.Category;

public class TaskListMacro extends BaseMacro
{
    private static final Category log = Category.getInstance(TaskListMacro.class);
    private ContentPropertyManager contentPropertyManager;
    private SubRenderer subRenderer;

    public boolean isInline() {
        return false;
    }

    public boolean hasBody() {
        return true;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        // retrieve the first parameter passed, in our case the name of the task list.
        String listName = (String) parameters.get("0");
        if (listName == null) listName = "";

        // retrieve a reference to the body object this macro is in
        ContentEntityObject contentObject = ((PageContext)renderContext).getEntity();

        TaskList taskList = new TaskList(listName, contentObject, body, contentPropertyManager, subRenderer, (PageContext)renderContext);

        // check if any request parameters came in to complete or uncomplete tasks
        final HttpServletRequest request = ServletActionContext.getRequest();
        if (request != null && contentObject != null && taskList.getName().equals(request.getParameter("tasklist.name")))
        {
            String remoteUser  = request.getRemoteUser();

            if (request.getParameter("tasklist.complete") != null)
                taskList.completeTask(request.getParameter("tasklist.complete"), remoteUser);
            else if (request.getParameter("tasklist.uncomplete") != null)
                taskList.uncompleteTask(request.getParameter("tasklist.uncomplete"));
            else if (request.getParameter("tasklist.uncomplete.all") != null)
                taskList.uncompleteAllTasks();
        }

        // now create a simple velocity context and render a template for the output
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("tasklist", taskList);
        contextMap.put("content", contentObject);

        try
        {
            return VelocityUtils.getRenderedTemplate("templates/extra/tasklist/tasklistmacro.vm", contextMap);
        }
        catch (Exception e)
        {
            log.error("Error while trying to display TaskList!", e);
            throw new MacroException(e.getMessage());
        }
    }

    public void setContentPropertyManager(ContentPropertyManager contentPropertyManager) {
        this.contentPropertyManager = contentPropertyManager;
    }

    public void setSubRenderer(SubRenderer subRenderer) {
        this.subRenderer = subRenderer;
    }
}
