   /*
   // +----------------------------------------------------------------------+
   // | Copyright (c) 2004 Bitflux GmbH                                      |
   // +----------------------------------------------------------------------+
   // | Licensed under the Apache License, Version 2.0 (the "License");      |
   // | you may not use this file except in compliance with the License.     |
   // | You may obtain a copy of the License at                              |
   // | http://www.apache.org/licenses/LICENSE-2.0                           |
   // | Unless required by applicable law or agreed to in writing, software  |
   // | distributed under the License is distributed on an "AS IS" BASIS,    |
   // | WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or      |
   // | implied. See the License for the specific language governing         |
   // | permissions and limitations under the License.                       |
   // +----------------------------------------------------------------------+
   // | Author: Bitflux GmbH <devel@bitflux.ch>                              |
   // +----------------------------------------------------------------------+
   */

   var liveSearchReq = false;
   var t = null;
   var liveSearchLast = "";
   var isIE = false;

  var isSubmitted = false;

   // on !IE we only have to initialize it once
   if (window.XMLHttpRequest) {
      liveSearchReq = new XMLHttpRequest();
   }

   function liveSearchInit() {
      if (navigator.userAgent.indexOf("Safari") > 0) {
          document.getElementById('livesearch').addEventListener("keydown",liveSearchKeyPress,false);
      } else if (navigator.product == "Gecko") {
          document.getElementById('livesearch').addEventListener("keypress",liveSearchKeyPress,false);
      } else {
          document.getElementById('livesearch').attachEvent('onkeydown',liveSearchKeyPress);
          isIE = true;
      }
   }

   function liveSearchKeyPress(event) {
      if (event.keyCode == 40)
      //KEY DOWN
      {
          highlight = document.getElementById("searchhighlight");
          if (!highlight) {
              // alert("Not highlighted");
              highlight = document.getElementById("returnedSearchResult").firstChild;
          } else {
              highlight.removeAttribute("id");
              highlight = highlight.nextSibling;
          }
          // alert(document.getElementById("returnedSearchResult").firstChild.innerHTML);
          if (highlight) {
              highlight.setAttribute("id","searchhighlight");
          }
          if (!isIE) { event.preventDefault(); }
      }
      //KEY UP
      else if (event.keyCode == 38) {
          highlight = document.getElementById("searchhighlight");
          if (!highlight) {
              highlight = document.getElementById("returnedSearchResult").lastChild.previousSibling;
          }
          else {
              highlight.removeAttribute("id");
              highlight = highlight.previousSibling;
          }
          if (highlight) {
              highlight.setAttribute("id","searchhighlight");
          }
          if (!isIE) { event.preventDefault(); }
      }
      //ESC
      else if (event.keyCode == 27) {
          closeLiveSearch();
      }
      else if (event.keyCode == 13) {
          highlight = document.getElementById("searchhighlight");

          isSubmitted = true;
          if (highlight) {
              selectedLink = highlight.getElementsByTagName("a")[0];
              if (highlight && selectedLink) {
                  window.location = selectedLink.getAttribute("href");
                  return false;
              }
          }

          isSubmitted = false;
          return true;
      }
   }

   function closeLiveSearch() {
      highlight = document.getElementById("searchhighlight");
      if (highlight) {
          highlight.removeAttribute("id");
      }
      document.getElementById("searchresult").style.display = "none";
      //document.forms.livesearchform.s.value = '';
   }

   function liveSearchStart() {
      if (t) { window.clearTimeout(t); }
      t = window.setTimeout("liveSearchDoSearch()",200);
   }

   function liveSearchDoSearch() {

      // don't send a request if the search term contains spaces or the first character is null, empty string, or a *
      firstCharacter = document.forms.livesearchform.s.value.charAt(0);
      noSpaces = (document.forms.livesearchform.s.value.search(" ")==-1);
      if (noSpaces && firstCharacter != "" && firstCharacter != " " && firstCharacter != "*")
      {
          if (liveSearchLast != document.forms.livesearchform.s.value) {
          if (liveSearchReq && liveSearchReq.readyState < 4) {
              liveSearchReq.abort();
          }
          if (document.forms.livesearchform.s.value == "") {
              document.getElementById("searchresult").style.display = "none";
              highlight = document.getElementById("searchhighlight");
              if (highlight) {
                  highlight.removeAttribute("id");
              }
              return false;
          }
          if (window.XMLHttpRequest) {
          // branch for IE/Windows ActiveX version
          } else if (window.ActiveXObject) {
              liveSearchReq = new ActiveXObject("Microsoft.XMLHTTP");
          }
          liveSearchReq.onreadystatechange= liveSearchProcessReqChange;
          liveSearchReq.open("GET", liveSearchRoot + "/plugins/livesearch/livesearch.action?decorator=none&searchQuery.queryString=" + document.forms.livesearchform.s.value + "*&spaceKey=" + document.forms.livesearchform.spaceKey.value);
          liveSearchLast = document.forms.livesearchform.s.value;
          liveSearchReq.send(null);
          }
      }
   }

   function liveSearchProcessReqChange() {
      if (liveSearchReq.readyState == 4) {
          var res = document.getElementById("searchresult");
          res.style.display = "block";
          res.firstChild.innerHTML = '<div id="searchcontrols"><div class="left">tip: use arrow keys + enter</div><div class="right"><a href="javascript://" title="Close results" onclick="closeLiveSearch();">close (esc)</a></div><br /></div><div id="searchheader">top search results:</div>'+liveSearchReq.responseText;

      }
   }

   function liveSearchSubmit() {
      if (!isSubmitted) {
        document.getElementById("livesearch.queryString").value = document.forms.livesearchform.s.value;
        return true;
      }
      else {
          return false;
      }
   }
  
   function closeResults() {
       document.getElementById("searchresult").style.display = "none";
   }
