package com.atlassian.confluence.extra.information;

import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.renderer.RenderContext;
import com.opensymphony.util.TextUtils;

import java.util.Map;

/**
 * Abstract support class for all information macros
 */
public abstract class AbstractInformationMacro extends BaseMacro
{
    private SubRenderer subRenderer;

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException
    {
        String title = null;

        String titleParam = (String) parameters.get("title");
        if (TextUtils.stringSet(titleParam))
            title = subRenderer.render(titleParam, renderContext, RenderMode.INLINE);

        boolean useIcon = true;

        String useIconParam = (String) parameters.get("icon");
        if (TextUtils.stringSet(useIconParam))
            useIcon = Boolean.valueOf(useIconParam).booleanValue();

        return ("<table cellpadding='5' width='85%' cellspacing='8px' class='" + getCssClass() + "' border=\"0\" align='center'><colgroup><col width='24'><col></colgroup><tr>" +
                (useIcon ? "<td valign='top'><img src=\"" + renderContext.getImagePath() + getIconLocation() + "\" width=\"16\" height=\"16\" align=\"absmiddle\" alt=\"\" border=\"0\"></td>" : "") +
                "<td>" + (title != null ? "<b class=\"strong\">" + title + "</b><br />" : "") +
                body + "</td></tr></table>");
    }

    public RenderMode getBodyRenderMode()
    {
        return RenderMode.suppress(RenderMode.F_FIRST_PARA);
    }

    public boolean hasBody()
    {
        return true;
    }

    public boolean isInline()
    {
        return false;
    }

    protected abstract String getIconLocation();

    protected abstract String getCssClass();

    public void setSubRenderer(SubRenderer subRenderer)
    {
        this.subRenderer = subRenderer;
    }
}
