package com.atlassian.confluence.extra.impresence;

import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.RenderContext;
import com.opensymphony.util.TextUtils;

import java.util.Map;

/**
 * A Yahoo! presence macro - see <a href="http://messenger.yahoo.com/messenger/help/online.html">Yahoo's info</a>.
 */
public class YahooPresenceMacro extends AbstractPresenceMacro
{
    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException
    {
        String id = getImId(parameters);
        if (!TextUtils.stringSet(id))
            return RenderUtils.error("No Yahoo! ID supplied");
        else
            return "<a title=\"Yahoo! " + id + "\" href=\"http://edit.yahoo.com/config/send_webmesg?.target=" + id + "&.src=pg\">\n" +
                    "<img border=0 align=\"absmiddle\" src=\"http://opi.yahoo.com/online?u=" + id + "&m=g&t=1\"></a>" +
                    (shouldShowId(parameters) ? "&nbsp;<a href=\"http://edit.yahoo.com/config/send_webmesg?.target=" + id + "&.src=pg\">" + id + "</a>" : "");
    }
}
