package com.atlassian.confluence.extra.impresence;

import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.RenderContext;
import com.opensymphony.util.TextUtils;

import java.util.Map;

public class ICQPresenceMacro extends AbstractPresenceMacro
{
    private static final String DEFAULT_IMAGE_SET = "5";

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException
    {
        String id = getImId(parameters);

        String image = DEFAULT_IMAGE_SET;

        if (parameters.get("image") != null)
            image = (String) parameters.get("image");

        if (!TextUtils.stringSet(id))
            return RenderUtils.error("No ICQ UIN supplied");
        else
            return "<a title=\"ICQ " + id + "\" href=\"http://wwp.icq.com/scripts/contact.dll?msgto=" + id + "\"><img border=\"0\" align=\"absmiddle\"" +
                    "src=\"http://status.icq.com/online.gif?icq=" + id + "&img=" + image + "\"></a>" +
                    (shouldShowId(parameters) ? "&nbsp<a title=\"ICQ " + id + "\" href=\"http://wwp.icq.com/scripts/contact.dll?msgto=" + id + "\">" + id + "</a>" : "");
    }

}
