package com.atlassian.confluence.extra.impresence;

import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.RenderContext;

import java.util.Map;

/**
 * A simple base class for our presence macros.
 */
public abstract class AbstractPresenceMacro extends BaseMacro
{
    public abstract String execute(Map parameters, String body, RenderContext renderContext) throws MacroException;

    public boolean isInline()
    {
        return true;
    }

    public boolean hasBody()
    {
        return false;
    }

    public RenderMode getBodyRenderMode()
    {
        return RenderMode.NO_RENDER;
    }

    /**
     * Retrieve the ID of their instant messaging client.
     */
    protected String getImId(Map parameters)
    {
        return (String) parameters.get("0");
    }

    /**
     * Whether or not to show the ID in the link.
     */
    protected boolean shouldShowId(Map parameters)
    {
        String showIdParam = (String) parameters.get("showid");
        return showIdParam == null || !"false".equalsIgnoreCase(showIdParam);
    }
}
