package com.atlassian.confluence.extra.impresence;

import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.renderer.v2.macro.ResourceAware;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.confluence.setup.BootstrapManager;
import com.opensymphony.util.TextUtils;

import java.util.Map;
import java.text.MessageFormat;

public class AIMPresenceMacro extends AbstractPresenceMacro implements ResourceAware
{
    private BootstrapManager bootstrapManager;
    private String imageSrc;
    private String resourcePath;

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException
    {
        String id = getImId(parameters);

        if (!TextUtils.stringSet(id))
            return RenderUtils.error("No AIM screen name supplied");
        else
            return "<a title=\"AIM " + id + "\" href=\"aim:goim?screenname=" + id + "\"><img border=\"0\" align=\"absmiddle\"" +
                    "src=\"" +  MessageFormat.format(imageSrc, new Object[] { id }) +"\"></a>" +
                    (shouldShowId(parameters) ? "&nbsp<a title=\"AIM " + id + "\" href=\"aim:goim?screenname=" + id + "\">" + id + "</a>" : "");
    }

    public void setResourcePath(String resourcePath)
    {
        this.resourcePath = resourcePath;
        this.imageSrc = "http://big.oscar.aol.com/{0}?on_url=" + bootstrapManager.getDomainName() + getResourcePath() + "/aimon.gif&off_url=" + bootstrapManager.getDomainName() + getResourcePath() + "/aimoff.gif";
    }

    public String getResourcePath()
    {
        return resourcePath;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager)
    {
        this.bootstrapManager = bootstrapManager;
    }
}
