package com.atlassian.confluence.extra.helloworld;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;
import javax.servlet.ServletConfig;
import java.io.IOException;

public class HelloWorldServlet extends HttpServlet
{
    private String defaultName = "World";

    public void init(ServletConfig servletConfig) throws ServletException
    {
        super.init(servletConfig);
        if (servletConfig.getInitParameter("defaultName") != null)
        {
            defaultName = servletConfig.getInitParameter("defaultName");
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {
        String name = defaultName;

        if (request.getParameter("name") != null)
        {
            name = request.getParameter("name");
        }

        response.getWriter().write("Hello " + name + "!");
        response.getWriter().flush();
        return;
    }
}
