package com.atlassian.confluence.extra.graphviz;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;

import java.util.Map;

public class GraphMacro
        extends BaseGraphVizMacro
{
    /**
     * Render a {graph} macro.
     * <p/>
     * The body of the macro is surrounded with 'graph {', '}' before being passed to dot.
     */
    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException
    {
        return GraphVizHelper.generateGraph("graph {\n" + body.trim() + "\n}",1,1, subRenderer, renderContext);
    }
}
