package com.atlassian.confluence.extra.graphviz;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;

import java.util.Map;

public class FlowChartMacro
        extends BaseGraphVizMacro
{
    /**
     * Render a {graph} macro.
     * <p/>
     * The body of the macro is surrounded with 'graph {', '}' and is given some formatting defaults before being passed to dot.
     */
    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException
    {
        String defaults =
                "edge [arrowsize=0.8]; node [shape=rect, style=filled, fillcolor=lightyellow, fontname=\"Verdana\", fontsize=9];";
        return GraphVizHelper.generateGraph("digraph {" + defaults + "\n" + body.trim() + "\n}",1,1, subRenderer, renderContext);
    }
}
