package com.atlassian.confluence.extra.graphviz;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;

import java.util.Map;

public class DiGraphMacro
        extends BaseGraphVizMacro
{
    /**
     * Render a {digraph} macro.
     * <p/>
     * The body of the macro is surrounded with 'digraph {', '}' before being passed to dot.
     */
    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException
    {
        return GraphVizHelper.generateGraph("digraph { \n" + body.trim() + "\n }",1,1, subRenderer, renderContext);
    }
}
