package com.atlassian.confluence.extra.favouritepages;

import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.pages.actions.ListPagesAction;

public class FavouritePageListAction extends AbstractSpaceAction implements SpaceAware
{
	private static final String PLUGIN_KEY = "list-favourites";

	public String execute() throws Exception
	{
		GeneralUtil.setCookie(ListPagesAction.LIST_PAGE_COOKIE, PLUGIN_KEY);
		return super.execute();
	}

	public boolean isSpaceRequired()
	{
		return true;
	}

	public boolean isViewPermissionRequired()
	{
		return true;
	}
}
