package com.atlassian.confluence.extra.dynamictasklist;

import com.atlassian.confluence.extra.dynamictasklist.model.Task;
import com.atlassian.confluence.extra.dynamictasklist.model.TaskList;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.security.Permission;
import com.opensymphony.util.TextUtils;

import java.util.StringTokenizer;

public class TaskListAction extends ConfluenceActionSupport
{
    private TaskListManager taskListManager;
    private ContentEntityObject entity;
    private String listName;
    private String taskNames;
    private String task;
    private long entityId;
    private ContentEntityManager contentEntityManager;

    /**
     * Rearange Task List Items.
     */
    public String reorderTasks()
    {
        if (taskNames != null)
        {
            TaskList list = getTaskList();
            StringTokenizer st = new StringTokenizer(taskNames, ",");
            int i = 0;
            while (st.hasMoreTokens())
            {
                String currentToken = st.nextToken();
                if (TextUtils.stringSet(currentToken))
                {
                    list.setTaskIndex(currentToken, i);
                    i++;
                }
            }

            taskListManager.saveTaskList(getEntity(), list);
        }

        return SUCCESS;
    }

    public void setTaskNames(String taskNames)
    {
        this.taskNames = taskNames;
    }

    public String addTask()
    {
        TaskList list = getTaskList();
        list.addTask(task);
        taskListManager.saveTaskList(getEntity(), list);
        return SUCCESS;
    }

    public String removeTask()
    {
        TaskList list = getTaskList();
        list.removeTask(task);
        taskListManager.saveTaskList(getEntity(), list);
        return SUCCESS;
    }

    public String completeTask()
    {
        TaskList list = getTaskList();
        Task taskObject = list.getTask(task);
        if (taskObject != null)
        {
            list.getTask(task).setCompleter((getRemoteUser() != null ? getRemoteUser().getName() : ""));
            taskListManager.saveTaskList(getEntity(), list);
            return SUCCESS;
        }
        return ERROR;
    }

    public String uncompleteTask()
    {
        TaskList list = getTaskList();
        Task taskObject = list.getTask(task);
        if (taskObject != null)
        {
            list.getTask(task).setCompleter(null);
            taskListManager.saveTaskList(getEntity(), list);
            return SUCCESS;
        }
        return ERROR;
    }

    public String getRedirectUrl()
    {
        return getEntity().getUrlPath();
    }

    public String getTask()
    {
        return task;
    }

    public void setTask(String task)
    {
        this.task = task;
    }

    public void setListName(String listName)
    {
        this.listName = listName;
    }

    public String getListName()
    {
        return listName;
    }

    private TaskList getTaskList()
    {
        return taskListManager.getTaskList(getEntity(), listName);
    }

    public void setTaskListManager(TaskListManager taskListManager)
    {
        this.taskListManager = taskListManager;
    }

    public Task getTaskObject()
    {
        TaskList list = getTaskList();

        return list.getTask(task);
    }

    public void setEntityId(long entityId)
    {
        this.entityId = entityId;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager)
    {
        this.contentEntityManager = contentEntityManager;
    }

    public boolean isPermitted()
    {
        return GeneralUtil.isSuperUser(getRemoteUser()) || permissionManager.hasPermission(getRemoteUser(), Permission.VIEW, getEntity());
    }

    public ContentEntityObject getEntity()
    {
        if (entity == null)
            entity =  contentEntityManager.getById(entityId);

        return entity;
    }

    public long getEntityId()
    {
        return entityId;
    }
}
