package com.atlassian.confluence.rpc.xmlrpc;

import junit.framework.TestCase;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class TestConfluenceXmlRpcHandler extends TestCase
{
    /**
     * It's against the spec for an XML-RPC method to have a void return value.
     * For methods that should return void, just return boolean 'true' instead.
     */
    public void testNothingReturnsVoid() throws Exception
    {
        Method[] methods = ConfluenceXmlRpcHandler.class.getMethods();
        List badMethods = new ArrayList();

        for (int i = 0; i < methods.length; i++)
        {
            Method method = methods[i];
            if (method.getReturnType() == Void.TYPE)
            {
                badMethods.add(method);
            }
        }

        if (badMethods.size() > 0)
            fail("XML-RPC methods can not return void: " + badMethods);
    }

    public void testStoreBlogEntry()
    {
        
    }
}
