/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 12, 2004
 * Time: 2:06:18 PM
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.rpc.soap.AbstractSoapTestCase;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.security.password.PasswordEncryptor;
import com.atlassian.user.repository.DefaultRepository;
import com.atlassian.user.impl.memory.provider.MemoryProvider;
import com.atlassian.user.impl.memory.MemoryUserManager;
import com.atlassian.user.impl.osuser.security.password.OSUPasswordEncryptor;

public class TestRemoteUser extends AbstractSoapTestCase
{
    MemoryProvider provider = new MemoryProvider();
    UserManager userManager;

    public void setUp() throws Exception
    {
        DefaultRepository repo = new DefaultRepository();
        PasswordEncryptor encryptor = new OSUPasswordEncryptor();
        userManager = new MemoryUserManager(repo, provider, encryptor);
        super.setUp();
    }

    public void tearDown() throws Exception
    {
        super.tearDown();
    }


    public void testCreation() throws Exception
    {
        User user = userManager.createUser("bob");
        user.setFullName("Bob Bubbles");
        user.setEmail("bob@bubbles.com");

        RemoteUser rUser = new RemoteUser(user);
        assertEquals("bob", rUser.getName());
        assertEquals("Bob Bubbles", rUser.getFullname());
        assertEquals("bob@bubbles.com", rUser.getEmail());
        assertEquals("http://foo.com/display/~bob", rUser.getUrl());
    }
}