/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 12, 2004
 * Time: 2:06:18 PM
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.rpc.soap.AbstractSoapTestCase;

public class TestRemoteSpaceSummary extends AbstractSoapTestCase
{
    public void testCreation()
    {
        Space space = makeSpace("FRUIT");
        space.setName("The Fruit Space");

        Space personalSpace = makeSpace("~bob");
        personalSpace.setName("Bob's Space");
        personalSpace.setSpaceType(SpaceType.PERSONAL);

        // test a basic page
        RemoteSpaceSummary rs = new RemoteSpaceSummary(space);
        assertEquals("FRUIT", rs.getKey());
        assertEquals("The Fruit Space", rs.getName());
        assertEquals("http://foo.com/display/FRUIT", rs.getUrl());

        // test a personal space
        RemoteSpaceSummary rsp = new RemoteSpaceSummary(personalSpace);
        assertEquals("~bob", rsp.getKey());
        assertEquals("Bob's Space", rsp.getName());
        assertEquals(SpaceType.PERSONAL.toString(), rsp.getType());
        assertEquals("http://foo.com/display/~bob", rsp.getUrl());
    }
}