/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 12, 2004
 * Time: 2:06:18 PM
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.pages.Page;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.rpc.soap.AbstractSoapTestCase;
import com.atlassian.renderer.WikiStyleRenderer;
import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;

public class TestRemoteSpace extends AbstractSoapTestCase
{
    public void testCreation()
    {
        Space space = makeSpace("FRUIT");
        space.setName("The Fruit Space");

        Page p = makePage(space, 4, "Apples");
        space.setHomePage(p);

        // test space with no description
        RemoteSpace rs = new RemoteSpace(space, null);
        assertEquals(4, rs.getHomePage());

        // now test the description works fine
        SpaceDescription description = new SpaceDescription();
        description.setContent("a space *about* fruit");
        space.setDescription(description);

        Mock renderer = new Mock(WikiStyleRenderer.class);
        renderer.expectAndReturn("convertWikiToXHtml", C.args(C.IS_NOT_NULL, C.eq("a space *about* fruit")), "a space <b>about</b> fruit");

        rs = new RemoteSpace(space, (WikiStyleRenderer) renderer.proxy());
        assertEquals("a space <b>about</b> fruit", rs.getDescription());
        renderer.verify();
    }

    public void testPersonalSpaceCreation()
    {
        Space space = makeSpace("~bob");
        space.setName("Bob's personal space");

        Page p = makePage(space, 5, "Bananas");
        space.setHomePage(p);

        
    }
}