/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 12, 2004
 * Time: 2:06:18 PM
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.rpc.soap.AbstractSoapTestCase;

public class TestRemoteSearchResult extends AbstractSoapTestCase
{
    public void testCreation()
    {
        Space space = makeSpace("FRUIT");
        Page p = makePage(space, 4, "Apples");
        p.setContent("the content");

        // test space with no description
        RemoteSearchResult rs = new RemoteSearchResult(p);
        assertEquals(4, rs.getId());
        assertEquals("Apples", rs.getTitle());
        assertEquals(Page.CONTENT_TYPE, rs.getType());
        assertEquals("http://foo.com/display/FRUIT/Apples", rs.getUrl());
        assertEquals("the content", rs.getExcerpt());
    }
}