/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 12, 2004
 * Time: 2:06:18 PM
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.rpc.soap.AbstractSoapTestCase;

public class TestRemotePageSummary extends AbstractSoapTestCase
{
    public void testCreation()
    {
        Space space = makeSpace("key");
        Page page = makePage(space, 10, "foo");

        // test a basic page
        RemotePageSummary rp = new RemotePageSummary(page);
        assertEquals(10, rp.getId());
        assertEquals("foo", rp.getTitle());
        assertEquals("key", rp.getSpace());
        assertEquals("http://foo.com/display/key/foo", rp.getUrl());

        // now create a parent
        Page parent = new Page();
        parent.setId(11);
        page.setParentPage(parent);

        // test the parent works
        rp = new RemotePageSummary(page);
        assertEquals(11, rp.getParentId());

    }
}