/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 12, 2004
 * Time: 2:06:18 PM
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.rpc.soap.AbstractSoapTestCase;

import java.util.Date;

public class TestRemotePageHistory extends AbstractSoapTestCase
{
    public void testCreation()
    {
        Page page = makePage(null, 10, "foo");
        page.setVersion(4);
        Date modified = new Date(1000000000);
        page.setLastModificationDate(modified);
        page.setLastModifierName("fred");

        // test a basic page
        RemotePageHistory rph = new RemotePageHistory(page);
        assertEquals(10, rph.getId());
        assertEquals(4, rph.getVersion());
        assertEquals(modified, rph.getModified());
        assertEquals("fred", rph.getModifier());
    }
}