/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 12, 2004
 * Time: 2:06:18 PM
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.rpc.soap.AbstractSoapTestCase;

import java.util.Date;

public class TestRemotePage extends AbstractSoapTestCase
{
    public void testCreation()
    {
        Space space = makeSpace("key");
        Page page = makePage(space, 10, "foo");
        page.setContent("the content");
        page.setVersion(4);
        Date created = new Date(1000000000);
        page.setCreationDate(created);
        page.setCreatorName("fred");

        // test a basic page
        RemotePage rp = new RemotePage(page);
        assertEquals(4, rp.getVersion());
        assertEquals("the content", rp.getContent());
        assertEquals(created, rp.getCreated());
        assertEquals("fred", rp.getCreator());
        assertFalse(rp.isHomePage());
        assertTrue(rp.isCurrent());

        // now set the homepage and check it works
        space.setHomePage(page);
        rp = new RemotePage(page);
        assertTrue(rp.isHomePage());
    }
}