/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 12, 2004
 * Time: 3:32:44 PM
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.rpc.soap.AbstractSoapTestCase;

public class TestRemoteComment extends AbstractSoapTestCase
{
    public void testCreation()
    {
        Space space = makeSpace("FRUIT");
        Page p = makePage(space, 4, "Bananas");

        Comment comment = new Comment();
        comment.setId(10);
        comment.setPage(p);
        comment.setContent("the content");
        comment.setCreatorName("bob");

        RemoteComment rc = new RemoteComment(comment);
        assertEquals(10, rc.getId());
        assertEquals(4, rc.getPageId());
        assertEquals("the content", rc.getContent());
        assertEquals("bob", rc.getCreator());
        assertEquals("Re: Bananas", rc.getTitle());
        assertEquals("http://foo.com/display/FRUIT/Bananas?focusedCommentId=10#comment-10", rc.getUrl());
    }
}