package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.rpc.soap.AbstractSoapTestCase;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.spaces.Space;

import java.util.Date;

public class TestRemoteBlogEntry extends AbstractSoapTestCase
{
    public void testCreation()
    {
        Space space = makeSpace("key");
        BlogPost blogPost = makeBlogPost(space, 1, "test blog post");
        blogPost.setCreationDate(new Date(100000));
        blogPost.setCreatorName("bob");
        blogPost.setContent("test content");

        RemoteBlogEntry rbe = new RemoteBlogEntry(blogPost);
        assertEquals(rbe.getPublishDate(), blogPost.getCreationDate());
        assertEquals(rbe.getAuthor(), blogPost.getCreatorName());
        assertEquals(rbe.getTitle(), blogPost.getTitle());
        assertEquals(rbe.getId(), blogPost.getId());
        assertEquals(rbe.getContent(), blogPost.getContent());
    }
}
