/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 12, 2004
 * Time: 3:32:44 PM
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.rpc.soap.AbstractSoapTestCase;
import com.atlassian.confluence.setup.DefaultBootstrapManager;
import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.confluence.setup.BootstrapManager;

public class TestRemoteAttachment extends AbstractSoapTestCase
{
    public void setUp() throws Exception
    {
        super.setUp();
        BootstrapUtils.getBootstrapManager().setProperty(BootstrapManager.ATTACHMENTS_DIR_PROP, "${confluenceHome}/attachments");
        BootstrapUtils.getBootstrapManager().setWebAppContextPath("");
    }

    public void tearDown() throws Exception
    {
        super.tearDown();
    }

    public void testCreation()
    {
        Page p = makePage(null, 4, "Bananas");

        Attachment attachment = new Attachment();
        attachment.setId(10);
        attachment.setContent(p);
        attachment.setContentType("text/html");
        attachment.setFileName("apples.pdf");
        attachment.setFileSize(2048);
        attachment.setCreatorName("bob");

        RemoteAttachment ra = new RemoteAttachment(attachment);
        assertEquals(10, ra.getId());
        assertEquals(4, ra.getPageId());
        assertEquals("text/html", ra.getContentType());
        assertEquals("apples.pdf", ra.getFileName());
        assertEquals(2048, ra.getFileSize());
        assertEquals("bob", ra.getCreator());
        assertEquals("apples.pdf", ra.getTitle());
        assertEquals("http://foo.com/download/attachments/4/apples.pdf?version=1", ra.getUrl());
    }
}