/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 12, 2004
 * Time: 3:45:30 PM
 */
package com.atlassian.confluence.rpc.soap;

import com.atlassian.confluence.ConfluenceTestCase;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.UserTestHelper;
import com.atlassian.user.User;
import com.mockobjects.dynamic.Mock;

public abstract class AbstractSoapTestCase extends ConfluenceTestCase
{
    protected User user;
    protected Mock mockPermissionManager;
    protected Mock mockSpacePermissionManager;
    protected Mock mockImportExportManager;
    protected UserAccessor userAccessor;
    protected Mock mockBootstrapManager = new Mock(BootstrapManager.class);

    public void setUp() throws Exception
    {
        super.setUp();

        userAccessor = UserTestHelper.getTestUserAccessor();
        GeneralUtil.setUserAccessor(userAccessor);

        user = userAccessor.createUser("bob");

        // setup mock objects
        mockPermissionManager = new Mock(PermissionManager.class);
        mockSpacePermissionManager = new Mock(SpacePermissionManager.class);
        mockImportExportManager = new Mock(ImportExportManager.class);

        BootstrapUtils.getBootstrapManager().setBaseUrl("http://foo.com");
    }

    public void tearDown() throws Exception
    {
        super.tearDown();

        UserTestHelper.removeAllTestEntities(userAccessor);
    }

    protected Page makePage(Space space, int id, String title)
    {
        Page p = new Page();
        p.setTitle(title);
        p.setId(id);
        p.setSpace(space);
        p.setContentStatus(Page.CURRENT);
        return p;
    }

    protected BlogPost makeBlogPost(Space space, int id, String title)
    {
        BlogPost blogPost = new BlogPost();
        blogPost.setId(id);
        blogPost.setTitle(title);
        blogPost.setSpace(space);
        return blogPost;
    }

    protected Space makeSpace(String key)
    {
        Space space = new Space();
        space.setKey(key);
        space.setName("A Space name");
        return space;
    }

}